.H 1 "OPENLOOK Interface"
This section describes the window layout,
use of the mouse and keyboard, and interactions with the window manager
for the version of pi that uses the OPENLOOK toolkit.
The toolkit runs on top of the X Window System and uses the
window manager and resource values to place and layout the windows.
Pi works best with the OPENLOOK window manager (olwm) since the toolkit
sets properties that are unique to it,
but other window managers may also be used.
.P
Pi's user interface distinguishes it from most other debuggers.
Instead of providing a centralized command language and a static set of menus,
pi's menus and keyboard languages dynamically depend on the
window, selected text within that window, and the state of the program.
For example, the menu for a line in a source
code window initially lets you set several types of breakpoints on that line.
Once a breakpoint is set, however, the menu entries for setting breakpoints
are replaced with an entry for removing the breakpoint.
.P
Customizing the menus to the current selection provides a
powerful user interface.
Instead of having to decide which of the available operators
are applicable, the system does it for you.
You may always determine what operations are possible from a line
by selecting it and looking at its menu.
.P
Customizing the keyboard interface to the selection allows
simple input sequences to invoke complex operators that would
not be possible with a centralized interpreter.
For example, the input language of a Frame window,
a window used to examine C expressions, accepts C expressions.
There are no difficult to remember commands that must be
typed in addition to the expressions.
Furthermore, the keyboard language for a line displaying a complex
expression in a Frame window allows that expression to be reused in
deriving new expressions with a single keystroke.
.H 2 "Mouse Buttons"
By default, the mouse buttons have the following bindings in OPENLOOK:
.DS I N
Button	Operator	Use
------	--------	---------------------------------------------
Left	SELECT		select text, default menu selections, buttons
Middle	ADJUST		adjust the text selection
Right	MENU		generate menus
.DE
.P
These may be changed by setting resources in your .Xdefaults file.
For instance, the lines:
.DS I N
*selectBtn:	<Button3>
*menuBtn:	<Button1>
.DE
.P
may be used to swap the SELECT and MENU buttons.
.H 2 "Window Manager"
Most X window managers surround windows with a title bars and borders,
and provide decorations for changing window layouts.
With olwm, pressing the MENU button in the border or title bar generates a
"Window" menu that allows that window to be closed, moved, reshaped, or hidden.
Pressing SELECT in the title bar or border fully exposes the window.
Pressing SELECT or ADJUST over the push-pin in the title bar pulls the
the pin out of the hole and closes the window.
.P
Pi may turned into an icon by closing the Keyboard Input window.
With olwm, this window may be closed by pressing SELECT on the title bar's
abbreviated menu button, or selecting "Close" in the "Window" menu generated
in either the title bar or border.
When the icon is opened, all of pi's windows are restored on the screen.
.P
With other window managers, see the window manager's manual pages for a
description of the window decorations and menus.
.H 2 "Window Layout"
A pi window contains a menu bar across the top of the window and a text region.
Horizontal and vertical scroll bars surround the text if the
window is too small to display it all.
.H 3 "Menu Bars"
The menu bar at the top of a window allows operators to be invoked from
buttons, menu buttons, and pop-up windows containing scrolling lists.
.P
Buttons are ovals with text in them, and are activated by moving the
cursor over the button and clicking SELECT.
.P
Menu buttons look like buttons, but have a down-pointing arrow
after the text.
Pressing MENU with the cursor on top of the menu button pops up the menu.
To invoke an operator, move the cursor over its menu entry and
release the MENU button.
If first menu entry is a push pin, placing the pin in the hole
causes the menu to be remain on the screen after the MENU button is
released - it becomes "pinned".
.P
Pinned menus are useful for repetitive operations, such as statement stepping,
and may be moved on the screen with the window manager.
To invoke operators in a pinned menu, move the cursor over the desired entry
and click SELECT or MENU.
Clicking multiple times invokes the operator multiple times.
With olwm, pinned menus may be popped down by taking the
pin out of the hole in the menu's title bar with the SELECT button. 
If a pinned menu becomes hidden by another window, clicking the MENU button
on top of its menu button raises it to the top of the window hierarchy.
.P
Pressing SELECT over a menu button invokes the default menu entry.
For most pi menus, this puts the menu's push pin into
the hole and pins the menu on the screen.
.P
Scrolling lists are used when there are more than 13 entries in a menu.
In the menu bar they look like buttons, but the text is followed by "..."
to indicate a window will pop up.
To pop up the scrolling list, move the cursor over the button and click SELECT.
With olwm, the scrolling list may be popped down by pulling the push pin
out of the hole with SELECT.
To select entries in the scrolling list, use the scroll bar to display
the desired entry, move the cursor over it, and click SELECT.
If a scrolling list is hidden by another window,
clicking SELECT on its button in the menu bar raises it.
.H 3 "Edit Menu"
Every menu bar has an "edit" menu button with the following operators:
.VL 10 1
.LI "send"
Send the text selected in the window to the Keyboard Input window.
This is an accelerator for selecting "copy",
moving to the Keyboard Input window and selecting "paste" in its Edit menu.
This is the default menu entry, so selected text can be sent to the Keyboard
window by simply clicking SELECT on the "edit" menu button.
.LI "cut"
Remove the selected lines from the window.
Partially selected lines are treated as if the whole
line is selected.
Some windows, such as the Source Text window, do not allow lines to be
removed from the window.
.LI "clear"
Equivalent to applying "cut" to every line in the window.
This entry is used to clean up.
.LI "copy"
Copy the selected text into the window system cut buffer.
.LI "close"
Remove the window from the screen.
If you are using olwm, you may alternatively pull the push pin
out of the hole with the SELECT button, or choose "dismiss"
in the menu generated by the MENU button in
the window's title bar or border.
.P
Closing a window may have side effects in the debugger. 
For example, closing a Process window closes all windows
associated with that process and detaches the debugger from the process.
.LI "help"
Entries in this sub-menu open the Help window and scroll to the sections
that describe the window and its operators.
The menu may have "overview", "menu bar", "keyboard", "line menus", and
"line keyboard" entries.
.LE
.H 3 "Line Menus"
In the text region of a window the MENU button generates a menu, called
the line menu, that depends on the line containing the start
of the currently selected text.
Each line may generate a unique line menu.
For example, a line of source code in a Source Text window generates a
menu that allows breakpoints to be set, the source to be disassembled,
or the function's Frame window to be opened.
.P
If the line menu contains less than 13 entries a pop-up menu is generated.
Cascading menus, indicated by menu entries with right-pointing
arrows on the right side, are used to group common operators in sub-menus.
Pi menus only cascade one level.
.P
When the line menu has more than 13 entires a scrolling list pop-up window
is generated and remains on the screen when the MENU button is released.
The SELECT button invokes operators in the scrolling list.
The scrolling list is popped down when any other line menu is generated.
With olwm, it may also be popped down by pulling
out the push pin in the title bar.
.H 2 "Keyboard Input Window"
The Keyboard Input window is used to edit and send keyboard input
to the selected line or window.
Closing this window turns the whole application into an icon.
.P
The Keyboard Input window's control area has a "windows" menu that
allows you to access all the windows.
Selecting an entry opens that windows, or exposes it if it is already open.
The control area also has "Window" and "Line" fields that display the
window and line with the current keyboard focus.
The "Line" field displays the line number, or "None" if the selected line
does not accept keyboard input.
The keyboard focus is set by moving the mouse into the text
region of a window and typing any key or using the SELECT or
ADJUST buttons to select text.
If a selection spans multiple lines, the keyboard focus is set to the line
containing the beginning of the selection.
.P
Text may be entered several ways:
.AL 1
.LI
Type into any pi window.
The characters are echoed in the Keyboard Input window.
The backspace key may be used to delete the previous character.
.LI
Use the "send" entry in the "edit" menu available in any window's menu bar
to copy that windows selected text into the Keyboard Input window's
insertion point.
.LI
Type directly into the Keyboard Input window.
.LI
Use the "edit" menu in Keyboard Input window, generated by the
MENU button in the text region, to paste in text from other windows.
.LE
.P
The text is sent to the selected line or window when a carriage return is
appended to the end of Keyboard Input window, so the keyboard focus
is only important when the carriage return is entered.
This allows complicated expressions to be grabbed from one window
and sent to a second window's keyboard interpreter.
Just move the cursor into the second window before typing the carriage return.
.P
If all the lines in a window accept keyboard input, it is still possible to
send keyboard input to the window's keyboard interpreter by selecting
the window's last line.
A dummy blank line is inserted at the bottom of each window for this purpose.
.P
The following input strings have special meanings:
.VL 15 1
.LI "?"
Open the Help window and scroll to the section describing
the keyboard language of the selected line or window.
.LI "<shell_cmd"
Run the shell command and use its standard output as the keyboard input.
.LI ">shell_cmd"
Runs the shell command using the selected line or window as standard input.
.LE
.P
For example, if no line is selected the string
.DS I N
>cat > outfile
.DE
.P
dumps the contents of the selected window into the file outfile while
.DS I N
< cat infile
.DE
.P
uses the contents of infile as keyboard input.
.H 2 "X Resources"
Pi uses X11 fallback resources to set the default size and
positions of the windows, as well as other parameters.
The default values for Suns, SGIs, and PCs are shown below.
They may be overridden by placing entries in your personal
resource database (usually $HOME/.Xdefaults), or by installing a resource
defaults file named Pads in the X11 app-defaults directory.
.DS N N
X Resource			Sun (1152x900)	SGI (1280x1024)	PC (800x600)
-----------------------------	---------------	---------------	-------------
assembler.geometry:		275x400+673+445	275x400+683+495	235x250-7+330
breakpoint.geometry:		150x175+980+225	170x175+1000+26	235x250-7+330
frame.geometry:			350x175+460+225	350x175+460+265	325x110-7+180
globals.geometry:		350x175+460+225	350x175+460+265	325x110-7+180
journal.geometry:		500x160+480+20	500x160+480+50	235x250-7+330
keyboard.geometry:		400x125+40+65	400x125+40+95	325x110-7+31
memory.geometry:		200x200+940+667	200x200+960+727	235x250-7+330
pi.geometry:			500x160+460+30	500x160+460+60	425x110+18+31
process.geometry:		400x175+40+225	400x175+40+265	425x110+8+31
rtconnect.geometry:		500x160+480+20	500x160+480+50	425x110+8+31
rtpi.geometry:			500x160+460+30	500x160+460+60	425x110+18+31
signals.geometry:		200x200+940+435	200x200+960+485	235x250-7+330
source.geometry:		600x400+40+435	600x400+40+485	435x395+8+180
srcfiles.geometry:		140x175+825+225	140x175+835+265	235x250-7+330
usertypes.geometry:		275x400+653+435	275x400+663+485	235x250-7+330
help*charsVisible:		83		83		84
help*linesVisible:		50		50		38
wd*linesVisible:		4		4		4
*blinkRate:			0		0		0
TopLevelShell*Background:	grey80		grey70		grey
TopLevelShell*TextBackground:	white		midnight blue	orange
TopLevelShell*Caption.font: 	lucidasans-bold	screen13	fixed
TopLevelShell*font:	   lucidasanstypewriter	screen-bold13	fixed

The following resources are only set on the SGI:

"TopLevelShell*TextEdit.TextFontColor:		grey80
"TopLevelShell*TextEdit.font:			screen15
.DE
